  /*
   *  Object %name    : parser_atp_sst_authentication.c%
   *  State           :  %state%
   *  Creation date   :  Apr 06 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser_atp_sst_authentication.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/
#include "SST_SEP_ATP_Authenticators.h"
#include "SST_SEP_ATP_RsaAsymAuthenticator.h"
#include "SST_SEP_ATP_ECCAsymAuthenticator.h"
#include "parser_atp_sst_authentication.h"
#include "sep_utils.h"
/************************ Global Data ************************/
    DxByte_t*                              TST_Workspace;
    DxUint32_t                             TST_WorkspaceSizeInBytes ;
    DxUint8_t*                             GlobalMemBuff;
    DxUint8_t*                             CurrGlobalMemBuff;
    TST_ATP_PassAuthTestDataStruct*        TST_ATP_PassAuthObjectTestData;
    TST_ATP_RsaAuthTestDataStruct*         TST_ATP_RsaAuthObjectTestData;
    TST_ATP_AesKeyAuthTestDataStruct*      TST_ATP_AesKeyAuthObjectTestData;
    TST_ATP_ECCAuthTestDataStruct*         TST_ATP_ECCAuthObjectTestData;
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_PasswordAuthenticator
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_PasswordAuthenticator
* function and calls the SEP function.
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_PasswordAuthenticator(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t  SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;


    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
     SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                  &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
    {
       TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
      goto End;
    }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_PassAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_PassAuthObjectTestData = (TST_ATP_PassAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

     /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_PassAuthObjectTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_PassAuthTestDataStruct));
    

    /*5. call QA SEP function */
    SEP_Error = SEPQA_SST_PasswordAuthenticator();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_PasswordAuthenticator test");

End:
    /*6. free allocated memory */
    DX_VOS_MemFree(GlobalMemBuff);

    /*7. end SEP message and return */
      msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_PasAuthenticator_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_RsaAsymAuthenticator
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_RsaAsymAuthenticator
* function and calls the SEP function.
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_RsaAsymAuthenticator(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t  SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
     SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                  &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
    {
       TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
      goto End;
    }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_RsaAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_RsaAuthObjectTestData = (TST_ATP_RsaAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

    /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_RsaAuthObjectTestData[0], 
                      &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                      sizeof(TST_ATP_RsaAuthTestDataStruct));

    /*5. call QA SEP function */
    SEP_Error = SEPQA_SST_RsaAsymAuthenticator();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_RsaAsymAuthenticator test");

End:
    /*6. free allocated GlobalMemBuff*/
    DX_VOS_MemFree(GlobalMemBuff);

    /*7. end SEP message and return */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_RsaAsymAuthenticator_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_AesKeyAsymAuthenticator
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application AES not integrated
* AES function.
* It calls the SEP function with parameters parsed from input message
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_AesKeyAsymAuthenticator(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t    SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
     SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                  &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
    {
       TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
      goto End;
    }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3.allocate buffer for TST_ATP_AesKeyAuthObjectTestData struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_AesKeyAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
    TST_ATP_AesKeyAuthObjectTestData = (TST_ATP_AesKeyAuthTestDataStruct*)CurrGlobalMemBuff;
    CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_AesKeyAuthTestDataStruct);
    }

    /*4. extract parameters from the message */
    DX_VOS_FastMemCpy(&TST_ATP_AesKeyAuthObjectTestData[0], 
                      &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                      sizeof(TST_ATP_AesKeyAuthTestDataStruct));

    /*5. call QA SEP function*/
    SEP_Error = SEPQA_SST_AesKeyAsymAuthenticator();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"DX_SEP_SST_PARSER_AesKeyAsymAuthenticator test");

End:
    /*6. free allocated buffer */
    DX_VOS_MemFree(GlobalMemBuff);

    /* 7. end SEP message and return */
    /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_AesKeyAsymAuthenticator_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_ECCAsymAuthenticator
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application ECCAsymAuthenticator function.
* It calls the SEP function with parameters parsed from input message
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/
DxUint32_t DX_SEP_SST_PARSER_ECCAsymAuthenticator(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t  SEP_Error = DX_SUCCESS;

    TST_Workspace = DX_NULL;
    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;

    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
     SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                  &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
    {
       TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
      goto End;
    }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff=GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff + sizeof(TST_ATP_ECCAuthTestDataStruct))>(GlobalMemBuff + TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_ECCAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_ECCAuthObjectTestData = (TST_ATP_ECCAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_ECCAuthTestDataStruct);
    }

    /*4. extract parameters from the message */
    /******************************************/
    DX_VOS_FastMemCpy(&TST_ATP_ECCAuthObjectTestData[0], 
                      &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                      sizeof(TST_ATP_ECCAuthTestDataStruct));

    /*5. call QA SEP function*/
    SEP_Error = SEPQA_SST_ECCAsymAuthenticator();

    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_ECCAuthenticator test");

End:
    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    DX_VOS_MemFree(GlobalMemBuff);

    /*6. free allocated GlobalMemBuff */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_ECCAsymAuthenticator_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
